/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.DisturbAbility;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class KatildasRisingDawn
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent(SubType.VAMPIRE, "Vampires");
    private static final FilterPermanent filter2 = new FilterControlledPermanent("permanents you control that are Spirits and/or enchantments");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public KatildasRisingDawn(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.AURA);
        this.color.setWhite(true);
        this.nightCard = true;
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new GainAbilityAttachedEffect((Ability)FlyingAbility.getInstance(), AttachmentType.AURA));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)LifelinkAbility.getInstance(), AttachmentType.AURA).setText(", lifelink"));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)new ProtectionAbility((Filter)filter), AttachmentType.AURA).setText(", and protection from Vampires"));
        ability.addEffect((Effect)new BoostEquippedEffect(xValue, xValue).setText(", and it gets +X/+X, where X is the number of permanents you control that are Spirits and/or enchantments"));
        this.addAbility(ability.addHint(hint));
        this.addAbility(DisturbAbility.makeBackAbility());
    }

    private KatildasRisingDawn(KatildasRisingDawn card) {
        super((CardImpl)card);
    }

    public KatildasRisingDawn copy() {
        return new KatildasRisingDawn(this);
    }

    static {
        filter2.add(Predicates.or((Predicate)SubType.SPIRIT.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
        xValue = new PermanentsOnBattlefieldCount(filter2);
        hint = new ValueHint("Spirits and enchantments you control", xValue);
    }
}

