/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KatsumasaTheAnimatorEffect
extends OneShotEffect {
    KatsumasaTheAnimatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "until end of turn, target noncreature artifact you control becomes an artifact creature and gains flying. If it's not a Vehicle, it has base power and toughness 1/1 until end of turn";
    }

    private KatsumasaTheAnimatorEffect(KatsumasaTheAnimatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public KatsumasaTheAnimatorEffect copy() {
        return new KatsumasaTheAnimatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AddCardTypeTargetEffect(Duration.EndOfTurn, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}), source);
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn), source);
        if (!permanent.hasSubtype(SubType.VEHICLE, game)) {
            game.addEffect((ContinuousEffect)new SetBasePowerToughnessTargetEffect(1, 1, Duration.EndOfTurn), source);
        }
        return true;
    }
}

