/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class KaustEyesOfTheGladeWatcher
extends Watcher {
    private final Set<MageObjectReference> set = new HashSet<MageObjectReference>();

    KaustEyesOfTheGladeWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.TURNED_FACE_UP) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            this.set.add(new MageObjectReference((MageObject)permanent, game));
        }
    }

    public void reset() {
        this.set.clear();
        super.reset();
    }

    static boolean checkPermanent(Permanent permanent, Game game) {
        return ((KaustEyesOfTheGladeWatcher)game.getState().getWatcher(KaustEyesOfTheGladeWatcher.class)).set.contains(new MageObjectReference((MageObject)permanent, game));
    }
}

