/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.players.Player;

class KayaGeistHunterEffect
extends OneShotEffect {
    KayaGeistHunterEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all cards from all graveyards, then create a 1/1 white Spirit creature token with flying for each card exiled this way";
    }

    private KayaGeistHunterEffect(KayaGeistHunterEffect effect) {
        super((OneShotEffect)effect);
    }

    public KayaGeistHunterEffect copy() {
        return new KayaGeistHunterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).map(g -> g.getCards(game)).flatMap(Collection::stream).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        if (cards.isEmpty()) {
            return true;
        }
        new SpiritWhiteToken().putOntoBattlefield(cards.size(), game, source);
        return true;
    }
}

