/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KayaGhostAssassinEffect
extends OneShotEffect {
    KayaGhostAssassinEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile {this} or up to one target creature. Return that card to the battlefield under its owner's control at the beginning of your next upkeep. You lose 2 life";
    }

    private KayaGhostAssassinEffect(KayaGhostAssassinEffect effect) {
        super((OneShotEffect)effect);
    }

    public KayaGhostAssassinEffect copy() {
        return new KayaGhostAssassinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            if (this.getTargetPointer().getFirst(game, source) != null) {
                Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (targetCreature != null) {
                    int zcc = targetCreature.getZoneChangeCounter(game);
                    if (controller.moveCards((Card)targetCreature, Zone.EXILED, source, game)) {
                        ReturnToBattlefieldUnderOwnerControlTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
                        effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature.getId(), zcc + 1));
                        AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility((Effect)effect);
                        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                    }
                }
            } else {
                int zcc = sourcePermanent.getZoneChangeCounter(game);
                if (controller.moveCards((Card)sourcePermanent, Zone.EXILED, source, game)) {
                    ReturnToBattlefieldUnderOwnerControlTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent.getId(), zcc + 1));
                    AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility((Effect)effect);
                    game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                }
            }
            controller.loseLife(2, game, source, false);
            return true;
        }
        return false;
    }
}

