/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KayaIntangibleSlayerExileEffect
extends OneShotEffect {
    KayaIntangibleSlayerExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature or enchantment. If it wasn't an Aura, create a token that's a copy of it, except it's a 1/1 white Spirit creature with flying in addition to its other types";
    }

    private KayaIntangibleSlayerExileEffect(KayaIntangibleSlayerExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public KayaIntangibleSlayerExileEffect copy() {
        return new KayaIntangibleSlayerExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        if (permanent.hasSubtype(SubType.AURA, game)) {
            return true;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, CardType.CREATURE, false, 1, false, false, null, 1, 1, true);
        effect.setSavedPermanent(permanent);
        effect.setOnlyColor(ObjectColor.WHITE);
        effect.withAdditionalSubType(SubType.SPIRIT);
        effect.apply(game, source);
        return true;
    }
}

