/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.k.KayaSpiritsJusticeCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.functions.CopyApplier;

class KayaSpiritsJusticeCopyEffect
extends OneShotEffect {
    KayaSpiritsJusticeCopyEffect() {
        super(Outcome.Copy);
    }

    private KayaSpiritsJusticeCopyEffect(KayaSpiritsJusticeCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public KayaSpiritsJusticeCopyEffect copy() {
        return new KayaSpiritsJusticeCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent copyToPermanent = game.getPermanent(source.getFirstTarget());
        CardsImpl exiledCards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (controller == null || copyToPermanent == null || exiledCards.isEmpty()) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        if (!controller.chooseTarget(this.outcome, (Cards)exiledCards, (TargetCard)target, source, game)) {
            return false;
        }
        Card copyFromCard = game.getCard(target.getFirstTarget());
        if (copyFromCard == null) {
            return false;
        }
        PermanentCard newBlueprint = new PermanentCard(copyFromCard, source.getControllerId(), game);
        newBlueprint.assignNewId();
        KayaSpiritsJusticeCopyApplier applier = new KayaSpiritsJusticeCopyApplier();
        applier.apply(game, (MageObject)newBlueprint, source, copyToPermanent.getId());
        CopyEffect copyEffect = new CopyEffect(Duration.EndOfTurn, (MageObject)newBlueprint, copyToPermanent.getId());
        copyEffect.newId();
        copyEffect.setApplier((CopyApplier)applier);
        Ability newAbility = source.copy();
        copyEffect.init(newAbility, game);
        game.addEffect((ContinuousEffect)copyEffect, source);
        return true;
    }
}

