/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.k.KayaTheInexorableEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.game.permanent.token.Token;

class KayaTheInexorableTriggeredAbility
extends TriggeredAbilityImpl {
    public KayaTheInexorableTriggeredAbility() {
        super(Zone.ALL, null, false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private KayaTheInexorableTriggeredAbility(KayaTheInexorableTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE) {
            ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
            return zEvent.getFromZone() == Zone.BATTLEFIELD && (zEvent.getToZone() == Zone.GRAVEYARD || zEvent.getToZone() == Zone.EXILED);
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getTargetId().equals(this.getSourceId())) {
            this.getEffects().clear();
            this.addEffect((Effect)new KayaTheInexorableEffect(new MageObjectReference((MageObject)zEvent.getTarget(), game)));
            this.addEffect((Effect)new CreateTokenEffect((Token)new SpiritWhiteToken()));
            return true;
        }
        return false;
    }

    public KayaTheInexorableTriggeredAbility copy() {
        return new KayaTheInexorableTriggeredAbility(this);
    }

    public String getRule() {
        return "When {this} dies or is put into exile, return it to its owner's hand and create a 1/1 white Spirit creature token with flying.";
    }
}

