/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KayasWrathEffect
extends OneShotEffect {
    KayasWrathEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy all creatures. You gain life equal to the number of creatures you controlled that were destroyed this way.";
    }

    private KayasWrathEffect(KayasWrathEffect effect) {
        super((OneShotEffect)effect);
    }

    public KayasWrathEffect copy() {
        return new KayasWrathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int counter = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (permanent == null) continue;
            boolean isMine = permanent.isControlledBy(source.getControllerId());
            if (!permanent.destroy(source, game, false) || !isMine) continue;
            ++counter;
        }
        return new GainLifeEffect(counter).apply(game, source);
    }
}

