/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.hint.Hint;
import mage.constants.CardType;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

enum KeenEyedCuratorHint implements Hint
{
    instance;


    public String getText(Game game, Ability ability) {
        MageObject sourceObject = ability.getSourceObject(game);
        if (sourceObject == null) {
            return "Card types exiled: 0";
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)ability.getSourceId(), (int)sourceObject.getZoneChangeCounter(game));
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (exileZone == null) {
            return "Card types exiled: 0";
        }
        List types = exileZone.getCards(game).stream().map(card -> card.getCardType(game)).flatMap(Collection::stream).distinct().map(CardType::toString).sorted().collect(Collectors.toList());
        String details = types.isEmpty() ? "" : " (" + String.join((CharSequence)", ", types) + ")";
        return "Card types exiled: " + types.size() + details;
    }

    public Hint copy() {
        return this;
    }
}

