/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class KefkaDancingMadEffect
extends OneShotEffect {
    KefkaDancingMadEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile a card at random from each opponent's graveyard. You may cast any number of spells from among cards exiled this way without paying their mana costs. Then each player who owns a spell you cast this way loses life equal to its mana value";
    }

    private KefkaDancingMadEffect(KefkaDancingMadEffect effect) {
        super((OneShotEffect)effect);
    }

    public KefkaDancingMadEffect copy() {
        return new KefkaDancingMadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.add(player.getGraveyard().getRandom(game));
        }
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        KefkaDancingMadTracker tracker = new KefkaDancingMadTracker();
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD, (int)Integer.MAX_VALUE, (CardUtil.SpellCastTracker)tracker, (boolean)false);
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            tracker.loseLife(playerId, game, source);
        }
        return true;
    }

    private static final class KefkaDancingMadTracker
    implements CardUtil.SpellCastTracker {
        private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

        private KefkaDancingMadTracker() {
        }

        public boolean checkCard(Card card, Game game) {
            return true;
        }

        public void addCard(Card card, Ability source, Game game) {
            this.map.compute(card.getOwnerId(), (u, i) -> i == null ? card.getManaValue() : Integer.sum(i, card.getManaValue()));
        }

        private void loseLife(UUID playerId, Game game, Ability source) {
            int totalCost = this.map.getOrDefault(playerId, 0);
            if (totalCost > 0) {
                Optional.ofNullable(playerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.loseLife(totalCost, game, source, false));
            }
        }
    }
}

