/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KeldonBattlewagonBoostEffect
extends OneShotEffect {
    KeldonBattlewagonBoostEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} gets +X/+0 until end of turn, where X is the power of the creature tapped this way";
    }

    private KeldonBattlewagonBoostEffect(KeldonBattlewagonBoostEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent keldonBattlewagon = game.getPermanent(source.getSourceId());
        Permanent tappedCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (tappedCreature != null && keldonBattlewagon != null) {
            int amount = tappedCreature.getPower().getValue();
            game.addEffect((ContinuousEffect)new BoostSourceEffect(amount, 0, Duration.EndOfTurn), source);
        }
        return true;
    }

    public KeldonBattlewagonBoostEffect copy() {
        return new KeldonBattlewagonBoostEffect(this);
    }
}

