/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class KeldonFirebombersEffect
extends OneShotEffect {
    KeldonFirebombersEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "each player sacrifices all lands they control except for three";
    }

    private KeldonFirebombersEffect(KeldonFirebombersEffect effect) {
        super((OneShotEffect)effect);
    }

    public KeldonFirebombersEffect copy() {
        return new KeldonFirebombersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> landsToSacrifice = new ArrayList<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            int amount;
            Player player = game.getPlayer(playerId);
            if (player == null || (amount = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_LANDS, playerId, game).size() - 3) <= 0) continue;
            TargetSacrifice target = new TargetSacrifice(amount, (FilterPermanent)StaticFilters.FILTER_LANDS);
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            for (UUID landId : target.getTargets()) {
                Permanent land = game.getPermanent(landId);
                if (land == null) continue;
                landsToSacrifice.add(land);
            }
        }
        for (Permanent land : landsToSacrifice) {
            land.sacrifice(source, game);
        }
        return true;
    }
}

