/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class KellanDaringTravelerEffect
extends OneShotEffect {
    KellanDaringTravelerEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "reveal the top card of your library. If it's a creature card with mana value 3 or less, put it into your hand. Otherwise, you may put it into your graveyard.";
    }

    private KellanDaringTravelerEffect(KellanDaringTravelerEffect effect) {
        super((OneShotEffect)effect);
    }

    public KellanDaringTravelerEffect copy() {
        return new KellanDaringTravelerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        if (controller.getLibrary().hasCards()) {
            Card card = controller.getLibrary().getFromTop(game);
            CardsImpl cards = new CardsImpl(card);
            controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            if (card != null) {
                if (card.isCreature(game) && card.getManaValue() <= 3) {
                    controller.moveCards(card, Zone.HAND, source, game);
                } else if (controller.chooseUse(Outcome.Neutral, "Put " + card.getIdName() + " in your graveyard?", source, game)) {
                    controller.moveCards(card, Zone.GRAVEYARD, source, game);
                }
            }
        }
        return true;
    }
}

