/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;
import mage.watchers.common.CardsAmountDrawnThisTurnWatcher;

class KeranosGodOfStormsTriggeredAbility
extends TriggeredAbilityImpl {
    KeranosGodOfStormsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new InfoEffect(""), false);
    }

    private KeranosGodOfStormsTriggeredAbility(KeranosGodOfStormsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public KeranosGodOfStormsTriggeredAbility copy() {
        return new KeranosGodOfStormsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        if (!game.isActivePlayer(this.getControllerId())) {
            return false;
        }
        CardsAmountDrawnThisTurnWatcher watcher = (CardsAmountDrawnThisTurnWatcher)game.getState().getWatcher(CardsAmountDrawnThisTurnWatcher.class);
        if (watcher != null && watcher.getAmountCardsDrawn(event.getPlayerId()) != 1) {
            return false;
        }
        Card card = game.getCard(event.getTargetId());
        Player controller = game.getPlayer(this.getControllerId());
        Permanent sourcePermanent = (Permanent)this.getSourceObject(game);
        if (card == null || controller == null || sourcePermanent == null) {
            return false;
        }
        controller.revealCards(sourcePermanent.getIdName(), (Cards)new CardsImpl(card), game);
        this.getTargets().clear();
        this.getEffects().clear();
        if (card.isLand(game)) {
            this.addEffect((Effect)new DrawCardSourceControllerEffect(1));
        } else {
            this.addEffect((Effect)new DamageTargetEffect(3));
            this.addTarget((Target)new TargetAnyTarget());
        }
        return true;
    }

    public String getRule() {
        return "Reveal the first card you draw on each of your turns. Whenever you reveal a land card this way, draw a card. Whenever you reveal a nonland card this way, {this} deals 3 damage to any target.";
    }
}

