/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.k.KessDissidentMageWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class KessDissidentMageReplacementEffect
extends ReplacementEffectImpl {
    KessDissidentMageReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Exile);
        this.staticText = "If a card cast this way would be put into your graveyard, exile it instead";
    }

    private KessDissidentMageReplacementEffect(KessDissidentMageReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public KessDissidentMageReplacementEffect copy() {
        return new KessDissidentMageReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(event.getTargetId());
        if (controller != null && card != null) {
            return controller.moveCards(card, Zone.EXILED, source, game);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() == Zone.GRAVEYARD) {
            KessDissidentMageWatcher watcher = (KessDissidentMageWatcher)game.getState().getWatcher(KessDissidentMageWatcher.class);
            return watcher != null && source.getSourceId().equals(watcher.spellCastWasAllowedBy(new MageObjectReference(event.getTargetId(), game)));
        }
        return false;
    }
}

