/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RevealCardsFromLibraryUntilEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class KethekCrucibleGoliathEffect
extends OneShotEffect {
    KethekCrucibleGoliathEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another creature. If you do, reveal cards from the top of your library until you reveal a nonlegendary creature card with lesser mana value, put it onto the battlefield, then put the rest on the bottom of your library in a random order.";
    }

    private KethekCrucibleGoliathEffect(KethekCrucibleGoliathEffect effect) {
        super((OneShotEffect)effect);
    }

    public KethekCrucibleGoliathEffect copy() {
        return new KethekCrucibleGoliathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE);
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        int xValue = permanent.getManaValue();
        FilterCreatureCard filterCreatureCard = new FilterCreatureCard("nonlegendary creature card with lesser mana value");
        filterCreatureCard.add(Predicates.not((Predicate)SuperType.LEGENDARY.getPredicate()));
        filterCreatureCard.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue));
        RevealCardsFromLibraryUntilEffect effect = new RevealCardsFromLibraryUntilEffect((FilterCard)filterCreatureCard, PutCards.BATTLEFIELD, PutCards.BOTTOM_RANDOM);
        effect.apply(game, source);
        return true;
    }
}

