/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Objects;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.cards.k.KethisTheHiddenHandGraveyardEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class KethisTheHiddenHandEffect
extends ContinuousEffectImpl {
    KethisTheHiddenHandEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Until end of turn, each legendary card in your graveyard gains \"You may play this card from your graveyard.\"";
    }

    private KethisTheHiddenHandEffect(KethisTheHiddenHandEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (!this.getAffectedObjectsSet()) {
            return;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return;
        }
        player.getGraveyard().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).filter(card1 -> card1.isLegendary(game)).forEach(card -> this.affectedObjectList.add(new MageObjectReference((MageObject)card, game)));
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.getGraveyard().getCards(game).stream().filter(card -> this.affectedObjectList.stream().anyMatch(mor -> mor.refersTo((MageObject)card, game))).forEach(card -> {
            SimpleStaticAbility ability = new SimpleStaticAbility(Zone.GRAVEYARD, (Effect)new KethisTheHiddenHandGraveyardEffect());
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        });
        return true;
    }

    public KethisTheHiddenHandEffect copy() {
        return new KethisTheHiddenHandEffect(this);
    }
}

