/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class KheruMindEaterLookAtCardEffect
extends AsThoughEffectImpl {
    KheruMindEaterLookAtCardEffect() {
        super(AsThoughEffectType.LOOK_AT_FACE_DOWN, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may look at cards exiled with {this}";
    }

    private KheruMindEaterLookAtCardEffect(KheruMindEaterLookAtCardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public KheruMindEaterLookAtCardEffect copy() {
        return new KheruMindEaterLookAtCardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        if (affectedControllerId.equals(source.getControllerId()) && (card = game.getCard(objectId)) != null) {
            MageObject sourceObject = game.getObject(source);
            if (sourceObject == null) {
                return false;
            }
            UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            ExileZone exile = game.getExile().getExileZone(exileId);
            return exile != null && exile.contains((Object)objectId);
        }
        return false;
    }
}

