/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class KillSuitCultistEffect
extends ReplacementEffectImpl {
    KillSuitCultistEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.staticText = "The next time damage would be dealt to target creature this turn, destroy that creature instead";
    }

    private KillSuitCultistEffect(KillSuitCultistEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public KillSuitCultistEffect copy() {
        return new KillSuitCultistEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            permanent.destroy(source, game, false);
            return true;
        }
        return false;
    }
}

