/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.AsEntersBattlefieldAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ChosenSubtypePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class KindredBoon
extends CardImpl {
    private static final FilterControlledCreaturePermanent filterDivinity = new FilterControlledCreaturePermanent("Each creature you control with a divinity counter on it");

    public KindredBoon(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}{W}");
        this.addAbility((Ability)new AsEntersBattlefieldAbility((Effect)new ChooseCreatureTypeEffect(Outcome.AddAbility)));
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature you control of the chosen type");
        filter.add((ObjectSourcePlayerPredicate)ChosenSubtypePredicate.TRUE);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new AddCountersTargetEffect(CounterType.DIVINITY.createInstance()), (Cost)new ManaCostsImpl("{1}{W}"));
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.addAbility((Ability)ability);
        GainAbilityControlledEffect effect = new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.WhileOnBattlefield, (FilterPermanent)filterDivinity);
        effect.setText("Each creature you control with a divinity counter on it has indestructible");
        this.addAbility((Ability)new SimpleStaticAbility((Effect)effect));
    }

    private KindredBoon(KindredBoon card) {
        super((CardImpl)card);
    }

    public KindredBoon copy() {
        return new KindredBoon(this);
    }

    static {
        filterDivinity.add((Predicate)CounterType.DIVINITY.getPredicate());
    }
}

