/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MillCardsEachPlayerEffect;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInOpponentsGraveyard;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class KingNarfisBetrayalFirstEffect
extends OneShotEffect {
    private static final Effect millEffect = new MillCardsEachPlayerEffect(4, TargetController.EACH_PLAYER);
    private static final FilterCard filter = new FilterCard("creature or planeswalker card from each graveyard");

    KingNarfisBetrayalFirstEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player mills four cards. Then you may exile a creature or planeswalker card from each graveyard";
    }

    private KingNarfisBetrayalFirstEffect(KingNarfisBetrayalFirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public KingNarfisBetrayalFirstEffect copy() {
        return new KingNarfisBetrayalFirstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        millEffect.apply(game, source);
        if (controller.getGraveyard().count(filter, game) != 0 && controller.chooseUse(this.outcome, "Exile a creature or planeswalker card from your graveyard?", source, game)) {
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
            target.withNotTarget(true);
            if (controller.chooseTarget(this.outcome, (Cards)controller.getGraveyard(), (TargetCard)target, source, game)) {
                controller.moveCardsToExile(game.getCard(target.getFirstTarget()), source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null));
            }
        }
        for (UUID opponentId : game.getOpponents(controllerId)) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || opponent.getGraveyard().count(filter, game) == 0 || !controller.chooseUse(this.outcome, "Exile a creature or planeswalker card from " + opponent.getName() + "'s graveyard?", source, game)) continue;
            TargetCardInOpponentsGraveyard target = new TargetCardInOpponentsGraveyard(1, 1, filter, true);
            target.withNotTarget(true);
            if (!controller.chooseTarget(this.outcome, (Cards)opponent.getGraveyard(), (TargetCard)target, source, game)) continue;
            controller.moveCardsToExile(game.getCard(target.getFirstTarget()), source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null));
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

