/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class KithkinZealotEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public KithkinZealotEffect() {
        super(Outcome.Neutral);
        this.staticText = "you gain 1 life for each black and/or red permanent target opponent controls";
    }

    private KithkinZealotEffect(KithkinZealotEffect effect) {
        super((OneShotEffect)effect);
    }

    public KithkinZealotEffect copy() {
        return new KithkinZealotEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (you != null && opponent != null) {
            int amount = game.getBattlefield().countAll(filter, opponent.getId(), game);
            you.gainLife(amount, game, source);
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.BLACK), (Predicate)new ColorPredicate(ObjectColor.RED)));
    }
}

