/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.UnblockedPredicate;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class KjeldoranRoyalGuardEffect
extends ReplacementEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("unblocked creatures");

    KjeldoranRoyalGuardEffect() {
        super(Duration.EndOfTurn, Outcome.RedirectDamage);
        this.staticText = "All combat damage that would be dealt to you by unblocked creatures this turn is dealt to {this} instead";
    }

    private KjeldoranRoyalGuardEffect(KjeldoranRoyalGuardEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamagePlayerEvent damageEvent = (DamagePlayerEvent)event;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            permanent.damage(damageEvent.getAmount(), event.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable());
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent p;
        if (event.getPlayerId().equals(source.getControllerId()) && ((DamageEvent)event).isCombatDamage() && (p = game.getPermanent(source.getSourceId())) != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                if (!event.getSourceId().equals(permanent.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public KjeldoranRoyalGuardEffect copy() {
        return new KjeldoranRoyalGuardEffect(this);
    }

    static {
        filter.add((Predicate)UnblockedPredicate.instance);
    }
}

