/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterEnchantmentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class KnickknackOuphePutOntoBattlefieldEffect
extends OneShotEffect {
    KnickknackOuphePutOntoBattlefieldEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "reveal the top X cards of your library. You may put any number of Aura cards with mana value X or less from among them onto the battlefield. Then put all cards revealed this way that weren't put onto the battlefield on the bottom of your library in a random order";
    }

    private KnickknackOuphePutOntoBattlefieldEffect(KnickknackOuphePutOntoBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int count = GetXValue.instance.calculate(game, source, null);
            if (count > 0) {
                CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, count));
                controller.revealCards(source, (Cards)cards, game);
                FilterEnchantmentCard filter = new FilterEnchantmentCard("Aura cards with mana value " + count + " or less to put onto the battlefield");
                filter.add((Predicate)SubType.AURA.getPredicate());
                filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, count));
                if (cards.count((FilterCard)filter, controller.getId(), source, game) > 0) {
                    TargetCard targetAuras = new TargetCard(0, count, Zone.LIBRARY, (FilterCard)filter);
                    if (controller.choose(Outcome.PutCardInPlay, (Cards)cards, targetAuras, source, game)) {
                        targetAuras.getTargets().stream().forEach(arg_0 -> KnickknackOuphePutOntoBattlefieldEffect.lambda$apply$0((Cards)cards, game, controller, source, arg_0));
                        targetAuras.clearChosen();
                    } else {
                        game.informPlayers(controller.getLogName() + " didn't choose anything");
                    }
                } else {
                    game.informPlayers("No Aura cards with mana value " + count + " or less to choose.");
                }
                if (!cards.isEmpty()) {
                    PutCards.BOTTOM_RANDOM.moveCards(controller, (Cards)cards, source, game);
                }
            }
            return true;
        }
        return false;
    }

    public KnickknackOuphePutOntoBattlefieldEffect copy() {
        return new KnickknackOuphePutOntoBattlefieldEffect(this);
    }

    private static /* synthetic */ void lambda$apply$0(Cards cards, Game game, Player controller, Ability source, UUID t) {
        Card card = cards.get(t, game);
        if (card != null) {
            cards.remove(card);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
    }
}

