/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class KnightOfTheHolyNimbusReplacementEffect
extends ReplacementEffectImpl {
    KnightOfTheHolyNimbusReplacementEffect() {
        super(Duration.Custom, Outcome.Regenerate);
        this.staticText = "If {this} would be destroyed, regenerate it";
    }

    private KnightOfTheHolyNimbusReplacementEffect(KnightOfTheHolyNimbusReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent knightOfTheHolyNimbus = game.getPermanent(event.getTargetId());
        if (knightOfTheHolyNimbus != null && event.getAmount() == 0 && knightOfTheHolyNimbus.regenerate(source, game)) {
            game.informPlayers(source.getSourceObject(game).getName() + " has been regenerated.");
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DESTROY_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId() != null && event.getTargetId().equals(source.getSourceId());
    }

    public KnightOfTheHolyNimbusReplacementEffect copy() {
        return new KnightOfTheHolyNimbusReplacementEffect(this);
    }
}

