/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.k.KnightsOfTheBlackRoseWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KnightsOfTheBlackRoseTriggeredAbility
extends TriggeredAbilityImpl {
    public KnightsOfTheBlackRoseTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
        this.setTriggerPhrase("Whenever an opponent becomes the monarch, if you were the monarch as the turn began, ");
    }

    private KnightsOfTheBlackRoseTriggeredAbility(KnightsOfTheBlackRoseTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BECOMES_MONARCH;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        KnightsOfTheBlackRoseWatcher watcher = (KnightsOfTheBlackRoseWatcher)game.getState().getWatcher(KnightsOfTheBlackRoseWatcher.class);
        return watcher != null && this.isControlledBy(watcher.getMonarchIdAtTurnStart());
    }

    public KnightsOfTheBlackRoseTriggeredAbility copy() {
        return new KnightsOfTheBlackRoseTriggeredAbility(this);
    }
}

