/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromExileForSourceEffect;
import mage.abilities.effects.common.discard.DiscardHandControllerEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KnowledgeVaultReturnEffect
extends OneShotEffect {
    KnowledgeVaultReturnEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Sacrifice {this}. If you do, discard your hand, then put all cards exiled with {this} into their owner's hand";
    }

    private KnowledgeVaultReturnEffect(KnowledgeVaultReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public KnowledgeVaultReturnEffect copy() {
        return new KnowledgeVaultReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (sourcePermanent != null && controller != null) {
            if (sourcePermanent.sacrifice(source, game)) {
                new DiscardHandControllerEffect().apply(game, source);
                new ReturnFromExileForSourceEffect(Zone.HAND).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

