/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldControlledTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SaddleTargetMountEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SetTargetPointer;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;

public final class KolodinTriumphCaster
extends CardImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("Mounts and Vehicles you control");
    private static final FilterControlledPermanent mountFilter = new FilterControlledPermanent("Mount");
    private static final FilterControlledPermanent vehicleFilter = new FilterControlledPermanent("Vehicle");

    public KolodinTriumphCaster(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{R}{W}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.PILOT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(3);
        this.addAbility((Ability)new SimpleStaticAbility(Zone.BATTLEFIELD, (Effect)new GainAbilityControlledEffect((Ability)HasteAbility.getInstance(), Duration.WhileOnBattlefield, (FilterPermanent)filter)));
        this.addAbility((Ability)new EntersBattlefieldControlledTriggeredAbility(Zone.BATTLEFIELD, (Effect)new SaddleTargetMountEffect("it becomes saddled until end of turn"), (FilterPermanent)mountFilter, false, SetTargetPointer.PERMANENT));
        ContinuousEffect effect = new AddCardTypeTargetEffect(Duration.EndOfTurn, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}).setText("it becomes an artifact creature until end of turn");
        this.addAbility((Ability)new EntersBattlefieldControlledTriggeredAbility(Zone.BATTLEFIELD, (Effect)effect, (FilterPermanent)vehicleFilter, false, SetTargetPointer.PERMANENT));
    }

    private KolodinTriumphCaster(KolodinTriumphCaster card) {
        super((CardImpl)card);
    }

    public KolodinTriumphCaster copy() {
        return new KolodinTriumphCaster(this);
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.MOUNT.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
        mountFilter.add((Predicate)SubType.MOUNT.getPredicate());
        vehicleFilter.add((Predicate)SubType.VEHICLE.getPredicate());
    }
}

