/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetSource;

class KorChantEffect
extends RedirectionEffect {
    protected TargetSource target = new TargetSource();

    KorChantEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "all damage that would be dealt this turn to target creature you control by a source of your choice is dealt to another target creature instead";
    }

    private KorChantEffect(KorChantEffect effect) {
        super((RedirectionEffect)effect);
        this.target = effect.target;
    }

    public KorChantEffect copy() {
        return new KorChantEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.target.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(this.getTargetPointer().getFirst(game, source)) && event.getSourceId().equals(this.target.getFirstTarget())) {
            this.redirectTarget = (Target)source.getTargets().get(1);
            return true;
        }
        return false;
    }
}

