/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.CardType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class KorvoldGleefulGluttonWatcher
extends Watcher {
    private final Map<UUID, Set<CardType>> map = new HashMap<UUID, Set<CardType>>();

    KorvoldGleefulGluttonWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SACRIFICED_PERMANENT) {
            return;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent != null) {
            permanent.getCardType(game).forEach(type -> this.map.computeIfAbsent(event.getPlayerId(), k -> new HashSet()).add(type));
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    public int getNumberOfTypes(UUID playerId) {
        return this.map.computeIfAbsent(playerId, k -> new HashSet()).size();
    }
}

