/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class KozilekDiscardCost
extends CostImpl {
    public KozilekDiscardCost() {
        this.text = "discard a card with mana value X";
    }

    private KozilekDiscardCost(KozilekDiscardCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Spell targetSpell = game.getStack().getSpell(ability.getFirstTarget());
        if (targetSpell == null) {
            return false;
        }
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return false;
        }
        FilterCard filter = new FilterCard("card with mana value of " + targetSpell.getManaValue());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, targetSpell.getManaValue()));
        TargetCardInHand target = new TargetCardInHand(filter);
        this.getTargets().clear();
        this.getTargets().add((Target)target);
        if (this.getTargets().choose(Outcome.Discard, controllerId, source.getSourceId(), source, game)) {
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Card card = player.getHand().get(targetId, game);
                if (card == null) {
                    return false;
                }
                player.discard(card, true, source, game);
                this.paid = true;
            }
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        if (game.getStack().isEmpty()) {
            return false;
        }
        HashSet<Integer> stackCMC = new HashSet<Integer>();
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell)) continue;
            stackCMC.add(stackObject.getManaValue());
        }
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller != null) {
            for (Card card : controller.getHand().getCards(game)) {
                if (!stackCMC.contains(card.getManaValue())) continue;
                return true;
            }
        }
        return false;
    }

    public KozilekDiscardCost copy() {
        return new KozilekDiscardCost(this);
    }
}

