/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.ComparisonType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetadjustment.TargetAdjuster;
import mage.util.CardUtil;

enum KozileksCommandAdjuster implements TargetAdjuster
{
    instance;


    public void adjustTargets(Ability ability, Game game) {
        Mode mode = ability.getModes().getMode();
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)ability, (String)"X", (Object)0);
        for (Effect effect : mode.getEffects()) {
            if (!(effect instanceof ExileTargetEffect)) continue;
            Target target = (Target)mode.getTargets().get(0);
            if (target instanceof TargetCreaturePermanent) {
                mode.getTargets().clear();
                FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with mana value " + xValue + " or less");
                filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, xValue));
                mode.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
            }
            if (!(target instanceof TargetCardInGraveyard)) continue;
            mode.getTargets().clear();
            mode.addTarget((Target)new TargetCardInGraveyard(0, xValue, new FilterCard("cards from graveyards")));
        }
    }
}

