/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.FlipCoinEvent;
import mage.game.events.GameEvent;

class KrarksThumbEffect
extends ReplacementEffectImpl {
    KrarksThumbEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would flip a coin, instead flip two coins and ignore one.";
    }

    private KrarksThumbEffect(KrarksThumbEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public KrarksThumbEffect copy() {
        return new KrarksThumbEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        FlipCoinEvent flipCoinEvent = (FlipCoinEvent)event;
        flipCoinEvent.setFlipCount(1 + flipCoinEvent.getFlipCount());
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.FLIP_COIN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }
}

