/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageEverythingEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class KrazyKowEffect
extends OneShotEffect {
    KrazyKowEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. If you roll a 1, sacrifice {this} and it deals 3 damage to each creature and each player";
    }

    private KrazyKowEffect(KrazyKowEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int result;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (result = controller.rollDice(this.outcome, source, game, 6)) == 1) {
            new SacrificeSourceEffect().apply(game, source);
            return new DamageEverythingEffect(3).apply(game, source);
        }
        return false;
    }

    public KrazyKowEffect copy() {
        return new KrazyKowEffect(this);
    }
}

