/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.k.KrovikanVampireDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KrovikanVampireEffect
extends OneShotEffect {
    Set<UUID> creaturesAffected = new HashSet<UUID>();

    KrovikanVampireEffect() {
        super(Outcome.Neutral);
        this.staticText = "put that card onto the battlefield under your control. Sacrifice it when you lose control of {this}";
    }

    private KrovikanVampireEffect(KrovikanVampireEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent krovikanVampire = game.getPermanent(source.getSourceId());
        this.creaturesAffected = (Set)game.getState().getValue(source.getSourceId() + "creatureToGainControl");
        if (this.creaturesAffected != null && controller != null && krovikanVampire != null) {
            this.creaturesAffected.stream().map(creatureId -> {
                controller.moveCards(game.getCard(creatureId), Zone.BATTLEFIELD, source, game, false, false, false, null);
                return creatureId;
            }).map(creatureId -> {
                SacrificeTargetEffect effect = new SacrificeTargetEffect();
                effect.setText("Sacrifice this if Krovikan Vampire leaves the battlefield or its current controller loses control of it.");
                effect.setTargetPointer((TargetPointer)new FixedTarget(creatureId, game));
                return effect;
            }).map(effect -> new KrovikanVampireDelayedTriggeredAbility((Effect)effect, krovikanVampire.getId())).forEachOrdered(dTA -> game.addDelayedTriggeredAbility((DelayedTriggeredAbility)dTA, source));
            this.creaturesAffected.clear();
            return true;
        }
        return false;
    }

    public KrovikanVampireEffect copy() {
        return new KrovikanVampireEffect(this);
    }
}

