/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.k.DamagedByEnchantedWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class KumanosBlessingEffect
extends ReplacementEffectImpl {
    KumanosBlessingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If a creature dealt damage by enchanted creature this turn would die, exile it instead";
    }

    private KumanosBlessingEffect(KumanosBlessingEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public KumanosBlessingEffect copy() {
        return new KumanosBlessingEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        DamagedByEnchantedWatcher watcher;
        ZoneChangeEvent zce = (ZoneChangeEvent)event;
        if (zce.isDiesEvent() && (watcher = (DamagedByEnchantedWatcher)game.getState().getWatcher(DamagedByEnchantedWatcher.class, source.getSourceId())) != null) {
            return watcher.wasDamaged(zce.getTarget(), game);
        }
        return false;
    }
}

