/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.CardType;
import mage.game.Game;
import mage.players.Player;

enum PermanentTypesInGraveyardCount implements DynamicValue
{
    instance;


    public PermanentTypesInGraveyardCount copy() {
        return instance;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player player = game.getPlayer(sourceAbility.getControllerId());
        if (player == null) {
            return 0;
        }
        return player.getGraveyard().getCards(game).stream().map(card -> card.getCardType(game)).flatMap(types -> types.stream().filter(CardType::isPermanentType)).distinct().mapToInt(x -> 1).sum();
    }

    public String getMessage() {
        return "permanent types among cards in your graveyard";
    }
}

