/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.util.CardUtil;

class LairOfTheHydraEffect
extends OneShotEffect {
    LairOfTheHydraEffect() {
        super(Outcome.BecomeCreature);
        this.staticText = "Until end of turn, {this} becomes an X/X green Hydra creature. It's still a land. X can't be 0";
    }

    private LairOfTheHydraEffect(LairOfTheHydraEffect effect) {
        super((OneShotEffect)effect);
    }

    public LairOfTheHydraEffect copy() {
        return new LairOfTheHydraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        game.addEffect((ContinuousEffect)new BecomesCreatureSourceEffect((Token)new CreatureToken(xValue, xValue, "X/X green Hydra creature").withColor("G").withSubType(SubType.HYDRA), CardType.LAND, Duration.EndOfTurn), source);
        return true;
    }
}

