/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class LairwatchGiantTriggeredAbility
extends TriggeredAbilityImpl {
    LairwatchGiantTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainAbilitySourceEffect((Ability)FirstStrikeAbility.getInstance()));
    }

    private LairwatchGiantTriggeredAbility(LairwatchGiantTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LairwatchGiantTriggeredAbility copy() {
        return new LairwatchGiantTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_BLOCKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        if (permanent != null) {
            return permanent.getBlocking() > 1;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} blocks two or more creatures, it gains first strike until end of turn.";
    }
}

