/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.common.RaidCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.AbilityWord;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.watchers.Watcher;
import mage.watchers.common.PlayerAttackedWatcher;

class LaraCroftTombRaiderTriggeredAbility
extends TriggeredAbilityImpl {
    LaraCroftTombRaiderTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new TreasureToken()));
        this.setTriggerPhrase("At end of combat on your turn, if you attacked this turn, ");
        this.addWatcher((Watcher)new PlayerAttackedWatcher());
        this.setAbilityWord(AbilityWord.RAID);
    }

    private LaraCroftTombRaiderTriggeredAbility(LaraCroftTombRaiderTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LaraCroftTombRaiderTriggeredAbility copy() {
        return new LaraCroftTombRaiderTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_COMBAT_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.isActivePlayer(this.getControllerId());
    }

    public boolean checkInterveningIfClause(Game game) {
        return RaidCondition.instance.apply(game, (Ability)this);
    }
}

