/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageIdentifier;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class LaraCroftTombRaiderWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    LaraCroftTombRaiderWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case SPELL_CAST: 
            case LAND_PLAYED: {
                if (!event.hasApprovingIdentifier(MageIdentifier.LaraCroftTombRaiderWatcher)) break;
                this.map.compute(event.getPlayerId(), (u, i) -> i == null ? 1 : Integer.sum(i, -1));
            }
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static void incrementWatcher(UUID playerId, Game game) {
        ((LaraCroftTombRaiderWatcher)game.getState().getWatcher(LaraCroftTombRaiderWatcher.class)).map.compute(playerId, CardUtil::setOrIncrementValue);
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return ((LaraCroftTombRaiderWatcher)game.getState().getWatcher(LaraCroftTombRaiderWatcher.class)).map.getOrDefault(playerId, 0) > 0;
    }
}

