/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LashOutEffect
extends OneShotEffect {
    LashOutEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 3 damage to target creature. Clash with an opponent. If you win, {this} deals 3 damage to that creature's controller";
    }

    private LashOutEffect(LashOutEffect effect) {
        super((OneShotEffect)effect);
    }

    public LashOutEffect copy() {
        return new LashOutEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && creature != null) {
            Player creaturesController;
            creature.damage(3, source.getSourceId(), source, game, false, true);
            if (new ClashEffect().apply(game, source) && (creaturesController = game.getPlayer(creature.getControllerId())) != null) {
                creaturesController.damage(3, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

