/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantAttackAllEffect;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;

class LastNightTogetherDelayedCantAttackAbility
extends DelayedTriggeredAbility {
    private final UUID connectedTurnMod;

    LastNightTogetherDelayedCantAttackAbility(List<UUID> targets, Game game, UUID connectedTurnMod) {
        super(null, Duration.EndOfTurn);
        FilterCreaturePermanent filterRestriction = new FilterCreaturePermanent();
        Set targetRefs = targets.stream().map(x -> new MageObjectReference(x, game)).collect(Collectors.toSet());
        filterRestriction.add(Predicates.not((Predicate)new PermanentReferenceInCollectionPredicate(targetRefs)));
        this.addEffect((Effect)new CantAttackAllEffect(Duration.EndOfCombat, filterRestriction));
        this.usesStack = false;
        this.connectedTurnMod = connectedTurnMod;
    }

    LastNightTogetherDelayedCantAttackAbility(LastNightTogetherDelayedCantAttackAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.connectedTurnMod = ability.connectedTurnMod;
    }

    public LastNightTogetherDelayedCantAttackAbility copy() {
        return new LastNightTogetherDelayedCantAttackAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PHASE_CHANGED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PHASE_CHANGED && this.connectedTurnMod.equals(event.getSourceId());
    }

    public String getRule() {
        return "Only the chosen creatures can attack during that combat phase";
    }
}

