/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.RandomUtil;

class LastOneStandingEffect
extends OneShotEffect {
    LastOneStandingEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a creature at random, then destroy the rest.";
    }

    private LastOneStandingEffect(LastOneStandingEffect effect) {
        super((OneShotEffect)effect);
    }

    public LastOneStandingEffect copy() {
        return new LastOneStandingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List creatureList = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
        if (creatureList.size() < 2) {
            return true;
        }
        int toSave = RandomUtil.nextInt((int)creatureList.size());
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add(Predicates.not((Predicate)new PermanentIdPredicate(((Permanent)creatureList.get(toSave)).getId())));
        return new DestroyAllEffect((FilterPermanent)filter).apply(game, source);
    }
}

