/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.filter.predicate.permanent.BlockingPredicate;
import mage.game.Game;
import mage.players.Player;

class LavaStormEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();
    private static final FilterPermanent filter2 = new FilterCreaturePermanent();

    LavaStormEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 2 damage to each attacking creature or {this} deals 2 damage to each blocking creature.";
    }

    private LavaStormEffect(LavaStormEffect effect) {
        super((OneShotEffect)effect);
    }

    public LavaStormEffect copy() {
        return new LavaStormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(Outcome.Benefit, "Deal 2 damage to all attacking creatures or all blocking creatures?", null, "Attackers", "Blockers", source, game)) {
            return new DamageAllEffect(2, filter).apply(game, source);
        }
        return new DamageAllEffect(2, filter2).apply(game, source);
    }

    static {
        filter.add((Predicate)AttackingPredicate.instance);
        filter2.add((Predicate)BlockingPredicate.instance);
    }
}

