/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.EnchantedCreatureSubtypeCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class LavamancersSkill
extends CardImpl {
    public LavamancersSkill(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.AddAbility));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        SimpleActivatedAbility pingAbility = new SimpleActivatedAbility((Effect)new DamageTargetEffect(1), (Cost)new TapSourceCost());
        pingAbility.addTarget((Target)new TargetCreaturePermanent());
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAttachedEffect((Ability)pingAbility, AttachmentType.AURA, Duration.WhileOnBattlefield, "Enchanted creature has \"{T}: This creature deals 1 damage to target creature.\"")));
        SimpleActivatedAbility pingTwoAbility = new SimpleActivatedAbility((Effect)new DamageTargetEffect(2), (Cost)new TapSourceCost());
        pingTwoAbility.addTarget((Target)new TargetCreaturePermanent());
        GainAbilityAttachedEffect isWizardEffect = new GainAbilityAttachedEffect((Ability)pingTwoAbility, AttachmentType.AURA);
        SimpleStaticAbility ifWizardAbility = new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)isWizardEffect, (Condition)new EnchantedCreatureSubtypeCondition(SubType.WIZARD), "As long as enchanted creature is a Wizard, it has \"{T}: This creature deals 2 damage to target creature.\""));
        this.addAbility((Ability)ifWizardAbility);
    }

    private LavamancersSkill(LavamancersSkill card) {
        super((CardImpl)card);
    }

    public LavamancersSkill copy() {
        return new LavamancersSkill(this);
    }
}

