/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class LayBareEffect
extends OneShotEffect {
    LayBareEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at its controller's hand";
    }

    private LayBareEffect(LayBareEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Player player = game.getPlayer(source.getControllerId());
        Card target = (Card)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.STACK);
        if (target != null && (controller = game.getPlayer(target.getOwnerId())) != null && player != null) {
            player.lookAtCards("Lay Bare", controller.getHand(), game);
            return true;
        }
        return false;
    }

    public LayBareEffect copy() {
        return new LayBareEffect(this);
    }
}

