/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.l.LazavDimirMastermindCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.functions.CopyApplier;

class LazavDimirMastermindEffect
extends OneShotEffect {
    LazavDimirMastermindEffect() {
        super(Outcome.Copy);
        this.staticText = "you may have {this} become a copy of that card, except its name is Lazav, Dimir Mastermind, it's legendary in addition to its other types, and it has hexproof and this ability";
    }

    private LazavDimirMastermindEffect(LazavDimirMastermindEffect effect) {
        super((OneShotEffect)effect);
    }

    public LazavDimirMastermindEffect copy() {
        return new LazavDimirMastermindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent lazavDimirMastermind = game.getPermanent(source.getSourceId());
        PermanentCard newBluePrint = null;
        if (controller != null && lazavDimirMastermind != null) {
            Card copyFromCard = game.getCard(((FixedTarget)this.getTargetPointer()).getTarget());
            if (copyFromCard != null) {
                newBluePrint = new PermanentCard(copyFromCard, source.getControllerId(), game);
                newBluePrint.assignNewId();
                LazavDimirMastermindCopyApplier applier = new LazavDimirMastermindCopyApplier();
                applier.apply(game, (MageObject)newBluePrint, source, lazavDimirMastermind.getId());
                CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)newBluePrint, lazavDimirMastermind.getId());
                copyEffect.setApplier((CopyApplier)applier);
                Ability newAbility = source.copy();
                copyEffect.init(newAbility, game);
                game.addEffect((ContinuousEffect)copyEffect, newAbility);
            }
            return true;
        }
        return false;
    }
}

