/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.l.LazavTheMultifariousCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.util.functions.CopyApplier;

class LazavTheMultifariousEffect
extends OneShotEffect {
    LazavTheMultifariousEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of target creature card in your graveyard with mana value X, except its name is Lazav, the Multifarious, it's legendary in addition to its other types, and it has this ability";
    }

    private LazavTheMultifariousEffect(LazavTheMultifariousEffect effect) {
        super((OneShotEffect)effect);
    }

    public LazavTheMultifariousEffect copy() {
        return new LazavTheMultifariousEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent lazavTheMultifarious = game.getPermanent(source.getSourceId());
        PermanentCard newBluePrint = null;
        if (controller != null && lazavTheMultifarious != null) {
            Card copyFromCard = game.getCard(source.getFirstTarget());
            if (copyFromCard != null) {
                newBluePrint = new PermanentCard(copyFromCard, source.getControllerId(), game);
                newBluePrint.assignNewId();
                LazavTheMultifariousCopyApplier applier = new LazavTheMultifariousCopyApplier();
                applier.apply(game, (MageObject)newBluePrint, source, lazavTheMultifarious.getId());
                CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)newBluePrint, lazavTheMultifarious.getId());
                copyEffect.setApplier((CopyApplier)applier);
                Ability newAbility = source.copy();
                copyEffect.init(newAbility, game);
                game.addEffect((ContinuousEffect)copyEffect, newAbility);
            }
            return true;
        }
        return false;
    }
}

